package com.agilex.healthcare.veteranappointment.domain;

import com.agilex.healthcare.mobilehealthplatform.domain.Dateable;
import com.agilex.healthcare.mobilehealthplatform.domain.Facility;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;
import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;
import com.agilex.healthcare.veteranappointment.serializer.JsonDateSerializer;
import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import gov.va.vamf.scheduling.communitycare.domain.BookedCCAppointment;

import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.lang.reflect.Field;
import java.util.*;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "appointmentRequest", namespace = Namespace.VeteranAppointmentRequest)
@JsonAutoDetect
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
@JsonIgnoreProperties(ignoreUnknown = true)
public class VARAppointmentRequest extends PatientData implements Dateable, Comparable<VARAppointmentRequest> {
	private static final long serialVersionUID = -613294957626640127L;

	@XmlElement @JsonProperty("createdDate")
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	@JsonSerialize(using = JsonDateSerializer.class)
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "MM/dd/yyyy HH:mm:ss")
	private Date createdDate;

	@XmlElement @JsonProperty
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	@JsonSerialize(using = JsonDateSerializer.class)
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "MM/dd/yyyy HH:mm:ss")
	private Date lastUpdatedDate;

	@XmlElement @JsonProperty
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	@JsonSerialize(using = JsonDateSerializer.class)
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "MM/dd/yyyy HH:mm:ss")
	private Date deletedDate;

	@XmlTransient @JsonIgnore
	private boolean activeFlag = true;
	

	@JsonProperty @XmlElement
	private String appointmentDate;
	@JsonProperty @XmlElement
	private String appointmentTime;

	@JsonProperty @XmlElement
	private String optionDate1;
	@JsonProperty @XmlElement
	private String optionTime1;
	@JsonProperty @XmlElement
	private String optionDate2;
	@JsonProperty @XmlElement
	private String optionTime2;
	@JsonProperty @XmlElement
	private String optionDate3;
	@JsonProperty @XmlElement
	private String optionTime3;

	@JsonProperty @XmlElement
	private String status;
	@JsonProperty @XmlElement
	private String appointmentType;
	@JsonProperty @XmlElement
	private String visitType;

	@JsonProperty @XmlElement
	private Facility facility;
	@JsonProperty @XmlElement
	private String email;
	@JsonProperty @XmlElement
	private boolean textMessagingAllowed;
	@JsonProperty @XmlElement
	private String textMessagingPhoneNumber;
	@JsonProperty @XmlElement
	private String phoneNumber;

	@JsonProperty @XmlElement
	private String purposeOfVisit;
	@JsonProperty @XmlElement
	private String otherPurposeOfVisit;

	@JsonProperty @XmlElement
	private String providerId;
	@JsonProperty @XmlElement
	private String providerName;
	@JsonProperty @XmlElement
	private String providerPersonClass;
	@JsonProperty @XmlElement
	private String providerOption;
	
	@JsonProperty @XmlElement
	private boolean secondRequest;

	@JsonProperty @XmlElement
	private boolean secondRequestSubmitted;

	@JsonProperty @XmlElement
	private VARAppointmentRequest parentRequest;

	
	@JsonProperty @XmlElement
	private Patient patient;
	
	@JsonProperty @XmlElement
	private Set<String> bestTimetoCall = new HashSet<String>();
	
	@JsonProperty @XmlElement
	private List<VARAppointmentRequestDetailCode> appointmentRequestDetailCode = new LinkedList<VARAppointmentRequestDetailCode>();
	
	@JsonProperty @XmlElement
	private VARAppointmentRequestInProcess beingProcessedBy;

	@JsonProperty @XmlElement
	private boolean hasVeteranNewMessage;
	
	@JsonProperty @XmlElement
	private boolean hasProviderNewMessage;
	
	@JsonProperty @XmlElement
	private boolean providerSeenAppointmentRequest;
	
	@JsonProperty @XmlElement
	private boolean requestedPhoneCall;

	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	@JsonSerialize(using = JsonDateSerializer.class)
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "MM/dd/yyyy HH:mm:ss")
	@JsonProperty
	private Date bookedApptDateTime;

	@JsonProperty @XmlElement
	private String typeOfCareId;

	@JsonProperty
	@XmlElement
	private String reasonForVisit;

	@JsonProperty
	@XmlElement
	private String otherReasonForVisit;

	@JsonProperty
	@XmlElement
	private String additionalInformation;


	@JsonProperty
	@XmlElement
	private String friendlyLocationName;

	@JsonProperty
	@XmlElement
	private BookedCCAppointment bookedCCAppointment;
	// CC Appointments extend VAR appointments so we want to exclude all parent properties when deserializing.
	// Attempt was made to use reflection and java 8 streams but it would require a hibernate update
	// TODO (improvement) maybe not have CCAppointmentRequest extend this class and update FE so that everything would post and receive a VARAppointmentRequest but if it's CC it just includes the ccAppointmentRequest object with it's specific fields.
	@JsonProperty
	@XmlElement
	@JsonIgnoreProperties({"createdDate", "lastUpdatedDate", "deletedDate", "activeFlag", "appointmentDate", "appointmentTime", "optionDate1", "optionDate2", "optionDate3", "optionTime1", "optionTime2", "optionTime3", "status", "appointmentType", "visitType", "facility", "email", "textMessagingAllowed", "textMessagingPhoneNumber", "phoneNumber", "purposeOfVisit", "otherPurposeOfVisit", "providerId", "providerName", "providerPersonClass", "providerOption", "secondRequest", "secondRequestSubmitted", "parentRequest", "patient", "bestTimetoCall", "appointmentRequestDetailCode", "beingProcessedBy", "hasVeteranMessage", "hasProviderNewMessage", "providerSeenAppointmentRequest", "requestedPhoneCall", "bookedApptDateTime", "typeOfCareId", "reasonForVisit", "otherReasonForVisit", "additionalInformation", "patientId", "friendlyLocationName"})
	private CCAppointmentRequest ccAppointmentRequest;

	public String getAppointmentRequestId() {
		return this.getDataIdentifier().getUniqueId();
	}
	
	public void setAppointmentRequestId(String appointmentRequestId) {
		this.getDataIdentifier().setUniqueId(appointmentRequestId);
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Date getDeletedDate() {
		return deletedDate;
	}

	public void setDeletedDate(Date deletedDate) {
		this.deletedDate = deletedDate;
	}

	public boolean isActiveFlag() {
		return activeFlag;
	}

	public void setActiveFlag(boolean activeFlag) {
		this.activeFlag = activeFlag;
	}

	public String getOptionDate1() {
		return optionDate1;
	}

	public void setOptionDate1(String optionDate1) {
		this.optionDate1 = optionDate1;
	}

	public String getOptionTime1() {
		return optionTime1;
	}

	public void setOptionTime1(String optionTime1) {
		this.optionTime1 = optionTime1;
	}

	public String getOptionDate2() {
		return optionDate2;
	}

	public void setOptionDate2(String optionDate2) {
		this.optionDate2 = optionDate2;
	}

	public String getOptionTime2() {
		return optionTime2;
	}

	public void setOptionTime2(String optionTime2) {
		this.optionTime2 = optionTime2;
	}

	public String getOptionDate3() {
		return optionDate3;
	}

	public void setOptionDate3(String optionDate3) {
		this.optionDate3 = optionDate3;
	}

	public String getOptionTime3() {
		return optionTime3;
	}

	public void setOptionTime3(String optionTime3) {
		this.optionTime3 = optionTime3;
	}
	
	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getAppointmentType() {
		return appointmentType;
	}

	public void setAppointmentType(String appointmentType) {
		this.appointmentType = appointmentType;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getPhoneNumber() {
		return phoneNumber;
	}

	public void setPhoneNumber(String phoneNumber) {
		this.phoneNumber = phoneNumber;
	}

	@Override
	public Date getDate() {
		return createdDate;
	}
	
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("data identifier: ");
		sb.append(getDataIdentifier().getSystemId());
		sb.append(", ");
		sb.append(getDataIdentifier().getUniqueId());
		sb.append("\n");
		sb.append("patient identifier: ");
		sb.append(getPatientIdentifier().getAssigningAuthority());
		sb.append(", ");
		sb.append(getPatientIdentifier().getUniqueId());
		sb.append("\n");
		
		return sb.toString();
	}

	@Override
	public int compareTo(VARAppointmentRequest o) {
		int result;
		
		if (this.getCreatedDate() == null || o.getCreatedDate() == null) {
			if (this.getCreatedDate() == null && o.getCreatedDate() == null) {
				result = 0;
			} else if (this.getCreatedDate() == null) {
				result = -1;
			} else {
				result = 1;
			}
		} else {
			result = this.getCreatedDate().compareTo(o.getCreatedDate());
		}
	
		return result;
	}

	public String getVisitType() {
		return visitType;
	}

	public void setVisitType(String visitType) {
		this.visitType = visitType;
	}

	public String getPurposeOfVisit() {
		return purposeOfVisit;
	}

	public void setPurposeOfVisit(String purposeOfVisit) {
		this.purposeOfVisit = purposeOfVisit;
	}

	public Set<String> getBestTimetoCall() {
		return bestTimetoCall;
	}

	public void setBestTimetoCall(Set<String> bestTimetoCall) {
		this.bestTimetoCall = bestTimetoCall;
	}

	public String getOtherPurposeOfVisit() {
		return otherPurposeOfVisit;
	}

	public void setOtherPurposeOfVisit(String otherPurposeOfVisit) {
		this.otherPurposeOfVisit = otherPurposeOfVisit;
	}

	public String getProviderId() {
		return providerId;
	}

	public void setProviderId(String providerId) {
		this.providerId = providerId;
	}

	public String getProviderName() {
		return providerName;
	}

	public void setProviderName(String providerName) {
		this.providerName = providerName;
	}

	public String getProviderPersonClass() {
		return providerPersonClass;
	}

	public void setProviderPersonClass(String providerPersonClass) {
		this.providerPersonClass = providerPersonClass;
	}
	
	public String getProviderOption() {
		return providerOption;
	}

	public void setProviderOption(String providerOption) {
		this.providerOption = providerOption;
	}

	public Date getLastUpdatedDate() {
		return lastUpdatedDate;
	}

	public void setLastUpdatedDate(Date lastUpdatedDate) {
		this.lastUpdatedDate = lastUpdatedDate;
	}

	public boolean isSecondRequest() {
		return secondRequest;
	}

	public void setSecondRequest(boolean secondRequest) {
		this.secondRequest = secondRequest;
	}

	public Patient getPatient() {
		return patient;
	}

	public void setPatient(Patient patient) {
		this.patient = patient;
	}

	@Override
    public String getPatientId() {
		return getPatient().getPatientIdentifier().getUniqueId();
	}

	@Override
	public void setPatientId(String patientId) {
		getPatientIdentifier().setUniqueId(patientId);
		getPatient().getPatientIdentifier().setUniqueId(patientId);
	}

	public List<VARAppointmentRequestDetailCode> getAppointmentRequestDetailCode() {
		return appointmentRequestDetailCode;
	}

	public void setAppointmentRequestDetailCode(List<VARAppointmentRequestDetailCode> appointmentRequestDetailCode) {
		this.appointmentRequestDetailCode = appointmentRequestDetailCode;
	}

	public String getAppointmentDate() {
		return appointmentDate;
	}

	public void setAppointmentDate(String appointmentDate) {
		this.appointmentDate = appointmentDate;
	}

	public String getAppointmentTime() {
		return appointmentTime;
	}

	public void setAppointmentTime(String appointmentTime) {
		this.appointmentTime = appointmentTime;
	}

	public Facility getFacility() {
		return facility;
	}

	public void setFacility(Facility facility) {
		this.facility = facility;
	}
	public boolean isSecondRequestSubmitted() {
		return secondRequestSubmitted;
	}

	public void setSecondRequestSubmitted(boolean secondRequestSubmitted) {
		this.secondRequestSubmitted = secondRequestSubmitted;
	}

	public VARAppointmentRequest getParentRequest() {
		return parentRequest;
	}

	public void setParentRequest(VARAppointmentRequest parentRequest) {
		this.parentRequest = parentRequest;
	}

	public VARAppointmentRequestInProcess getBeingProcessedBy() {
		return beingProcessedBy;
	}

	public void setBeingProcessedBy(VARAppointmentRequestInProcess beingProcessedBy) {
		this.beingProcessedBy = beingProcessedBy;
	}

	public String getTextMessagingPhoneNumber() {
		return textMessagingPhoneNumber;
	}

	public void setTextMessagingPhoneNumber(String textMessagingPhoneNumber) {
		this.textMessagingPhoneNumber = textMessagingPhoneNumber;
	}

	public boolean isTextMessagingAllowed() {
		return textMessagingAllowed;
	}

	public void setTextMessagingAllowed(boolean textMessagingAllowed) {
		this.textMessagingAllowed = textMessagingAllowed;
	}

	public boolean isHasVeteranNewMessage() {
		return hasVeteranNewMessage;
	}

	public void setHasVeteranNewMessage(boolean hasVeteranNewMessage) {
		this.hasVeteranNewMessage = hasVeteranNewMessage;
	}

	public boolean isHasProviderNewMessage() {
		return hasProviderNewMessage;
	}

	public void setHasProviderNewMessage(boolean hasProviderNewMessage) {
		this.hasProviderNewMessage = hasProviderNewMessage;
	}
	
	public boolean isProviderSeenAppointmentRequest() {
		return providerSeenAppointmentRequest;
	}

	public void setProviderSeenAppointmentRequest(
			boolean providerSeenAppointmentRequest) {
		this.providerSeenAppointmentRequest = providerSeenAppointmentRequest;
	}

	public boolean isRequestedPhoneCall() {
		return requestedPhoneCall;
	}

	public void setRequestedPhoneCall(boolean requestedPhoneCall) {
		this.requestedPhoneCall = requestedPhoneCall;
	}

	public Date getBookedApptDateTime() {
		return bookedApptDateTime;
	}

	public void setBookedApptDateTime(Date bookedApptDateTime) {
		this.bookedApptDateTime = bookedApptDateTime;
	}

	public String getTypeOfCareId() {
		return typeOfCareId;
	}

	public void setTypeOfCareId (String typeOfCareId) {
		this.typeOfCareId = typeOfCareId;
	}

	public String getReasonForVisit() {
		return reasonForVisit;
	}

	public void setReasonForVisit(String reasonForVisit) {
		this.reasonForVisit = reasonForVisit;
	}

	public String getOtherReasonForVisit() {
		return otherReasonForVisit;
	}

	public void setOtherReasonForVisit(String otherReasonForVisit) {
		this.otherReasonForVisit = otherReasonForVisit;
	}

	public String getAdditionalInformation() {
		return additionalInformation;
	}

	public void setAdditionalInformation(String additionalInformation) {
		this.additionalInformation = additionalInformation;
	}

	public CCAppointmentRequest getCcAppointmentRequest() {
		return this.ccAppointmentRequest;
	}

	public  void setCcAppointmentRequest(CCAppointmentRequest ccAppointmentRequest) {
		this.ccAppointmentRequest = ccAppointmentRequest;
	}

	public String getFriendlyLocationName() {
		return friendlyLocationName;
	}

	public void setFriendlyLocationName(String friendlyLocationName) {
		this.friendlyLocationName = friendlyLocationName;
	}

	public BookedCCAppointment getBookedCCAppointment() {
		return bookedCCAppointment;
	}

	public void setBookedCCAppointment(BookedCCAppointment bookedCCAppointment) {
		this.bookedCCAppointment = bookedCCAppointment;
	}
}
